

/******************************************************************************************************
 **                                                                                                  **
 **                            Ex1 : Display Pixel on ET-DSP I2C LED 16x8                            **
 **                                                                                                  **
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : Arduino Mega32U4  (ET-Base AVR EASY32U4 LEONADO)                           **
 **                     : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.8.12                                                             **
 **                                                                                                  **                   
 **  Port Interface     :    Arduino Easy328                         ET-DSP I2C LED16x2              **
 **                         -----------------                       --------------------             **
 **    I2C HT16K33      :  PIN D2-SDA            Connect             SDA                             **                                                                                    
 **                            D3-SCL            Connect             SCL                             **
 **                                                                 I2C Address=0x70                 **
 **                                                                                                  **
 **  Operate : Plot pixel 4 conner of Display                                                        **     
 **                                                                                                  **
 **                                                                                                  **
 **  Create By          : Mr. Sittiphol Yooyod (WWW.ETTEAM.COM)                                      **
 **  Last Update        : 31/October/2020                                                            ** 
 **                                                                                                  ** 
 **                                 ==== ET-DSP I2C LED 16x2 ====                                    ** 
 **                          [axis-Y=0-7]                                                            **                                   
 **                              ^                                                                   **
 **                        Row   | Even Address       Odd Address --->    Colum                      **
 **                   (D7) ay7   o o o o o o o o    o o o o o o o o                                  ** 
 **                         ^    o             o    o             o                                  ** 
 **                         |    o             o    o             o                                  **
 **                         |    o             o    o             o                                  ** 
 **                         |    o             o    o             o                                  **
 **                         |    o             o    o             o                                  **
 **                         |    o             o    o             o                                  **  
 **                   (D0) ay0   o o o o o o o o    o o o o o o o o  ----->   [axis-x=0-15]          **
 **                             ax0           ax7  ax8            ax15                               **         
 **                                                                                                  **
 ******************************************************************************************************/


#include <Wire.h>


//-------- HT16K33 commands ---------
  #define HT16K33_CMD_SETUP   0x80
  #define HT16K33_CMD_DIMMING 0xE0 
  
//------- Value Setup for Command ---
  #define Osc_OFF      0x00
  #define Osc_ON       0x01
  #define DSP_OFF      0x00
  #define DSP_ON       0x01
  #define Blink_OFF    0x00
  #define Blink_2H     0x01
  #define Blink_1H     0x02
  #define Blink_0H5    0x03


const int I2C_Addr = 0x70; // HT16K33 default address
unsigned char dspBuf[17];
unsigned char BufOld[16];

 //------------- Setup --------------
void setup() 
{
 
  Wire.begin();  //Initial Start I2C 
  init_dsp()  ;

}



//================================= Main ================================
void loop() 
{
  Clr_buf(0) ; // Clear Display Buffer All
  
  Pixel(0,0)   ; //Plot Dot x=0,y=0
  Pixel(0,7)   ; //Plot Dot x=0,y=7
  Pixel(15,0)  ;
  Pixel(15,7)  ;


  Dsp_Show();
   
  while(1){;}
}
 
 

//==================================== Sub-Program ==========================================

//---------- Function Update Display All -------

void Dsp_Show()
{
  int nd ;
  Wire.beginTransmission(I2C_Addr);
  Wire.write(0x00)                ; // start at address 0x0
 
  for (nd = 0; nd < 8; nd++) 
  {
    Wire.write(dspBuf[nd])       ; //Write data from buffer array 0-7  for Colum(0-7) address even   
    Wire.write(dspBuf[nd+8])     ; //Write data from buffer array 8-15 for Colum(8-15) address odd    
   
  }
  Wire.endTransmission();  
}

//---------- Function Initial Display -------

void init_dsp()
 {
    Wire.beginTransmission(I2C_Addr)     ;
    Wire.write(0x20 | Osc_ON)            ; // turn on oscillator
    Wire.endTransmission()               ;

    DSP_OnOff(DSP_ON)   ;
    Dimmer(15)          ;     //Dimmer Max 
    Blink( Blink_OFF )  ;

    Clr_buf(0)          ;
    Dsp_Show()          ;
  
    delay(100)          ;

 }



//------ Function Clear data Buffer of display All -------
//        bg = Value data display buffer 0 or 1
//             0 : Data Buffer display all =0x00
//             1 : Data Buffer display all = 0xFF
//-----------------------------------------------------
 
void Clr_buf(int bg)
{
  int nb ;

  if((bg==0)||(bg==1)) //Check bg is 0 or 1 only
   {
     if(bg == 0)
        bg = 0    ;
     else 
       bg = 0xFF  ;
  
    for( nb = 0 ; nb < 8; nb++)
     {
       dspBuf[nb]   = bg;  //Write data to buffer array 0-7  for Colum(0-7) address even   
       dspBuf[nb+8] = bg;  //Write data to buffer array 8-15 for Colum(8-15) address odd  
     }
     
  } //if bg
}


 //------ Function Sets the brightness of the display -------
 //        dim = Value Brightness 0-15                      
 //-----------------------------------------------------------
void Dimmer(int dim)
 { 
  if(dim > 15) return;
  Wire.beginTransmission(I2C_Addr);
  Wire.write(HT16K33_CMD_DIMMING | dim); // Sent Dimming command
  Wire.endTransmission();
}


 //------ Function Set display Blinking  -------
 //        bk = Value blink 0-3
 //             0=Blink off
 //             1=blink 2Hz    
 //             2=blink 1Hz 
 //             3=blink 0.5Hz                   
 //----------------------------------------------

void Blink(int bk)
 {
  if(bk > 3) return;
 
  Wire.beginTransmission(I2C_Addr);
  Wire.write(HT16K33_CMD_SETUP | bk<<1 | DSP_ON ); //Sent blanking command
  Wire.endTransmission();
}


 //------ Function Set display On/Off  -------
 //        nf = Value ON/Off Display
 //             0=DSP OFF
 //             1=DSP ON               
 //----------------------------------------------

void DSP_OnOff(int nf)
{
  Wire.beginTransmission(I2C_Addr);
  Wire.write(HT16K33_CMD_SETUP | nf); //Sent On/Off Display
  Wire.endTransmission();

}


 //------ Function Plot Pixel Position other on Display  -------
 //        ax = Position axis X 0-15
 //        ay = Position axis Y 0-7     
 //                           
 //--------------------------------------------------------------
 
 void Pixel(unsigned char ax,unsigned char ay)
 {
   int pw=1,e ;
   
  if((ax>=0)&&(ax<16)&&(ay>=0)&&(ay<8))
  {
 
    for(e=1;e<=ay;e++)//Loop Power คำนวณเลขยกกำลัง
     {
       pw = 2*pw;                   
     }   
    dspBuf[ax] |=  pw   ;  //Keep data to position buffer for axis-x   
  }
}




 
